' ------------------------------------------------------------------------------
' --- Program pro vypocet casovace ---------------------------------------------
' ------------------------------------------------------------------------------

#include "vbcompat.bi"                                                          ' vlozeni hlavickoveho souboru

' ------------------------------------------------------------------------------
' --- Promenne a jejich dimenzovani --------------------------------------------
' ------------------------------------------------------------------------------

dim zadani as string, f as double, argv As String, rad as double, t as double
dim typ as double, tmax as double, tmin as double, pres as double, tp as double
dim x as double, tch as double, tcl as double, odchylka as double, p as ubyte
dim vysledky (0 to 65536) as double, vysledek as double, minimum as double
' ------------------------------------------------------------------------------
' --- Ziskani hodnoty parametru spusteni, pokud je -----------------------------
' ------------------------------------------------------------------------------

  argv = Command( 1 )                                           ' argv je pole obsahujici parametry spusteni

	if argv = "/h" then
	  goto napoveda
	elseif argv = "/v" then
	  goto verze
	endif
	  goto zacatek

' ------------------------------------------------------------------------------
' --- Ziskani hodnot od uzivatele ----------------------------------------------
' ------------------------------------------------------------------------------

zacatek:
color 10,0
cls

print
print "    Vypocet periody preruseni pro 8 a 16 bitovy casovac"
print "                    procesoru Atmel AVR
print "    ---------------------------------------------------"
print

color 7,0

' ------------------------------------------------------------------------------
' --- Hodinova frekvence procesoru ---------------------------------------------
' ------------------------------------------------------------------------------

frekvence:                                                                      
color 15,0 : print "Hodinova frekvence";
color 7,0 : print " [MHz/kHz/Hz] ";
color 15,0 : input " - ",zadani
color 7,0

if right (zadani,1) = "k" then                                                  ' Urceni radu krekvence
         rad=1000                                                               ' pokud je na konci "k" jsou to kHz
   elseif right (zadani,1) = "M" then                                           ' pokud tam je "M" jsou to MHz
         rad=1000000
   else                                                                         ' pokud tam je neco jineho, jsou to Hz
         rad = 1
endif

f = val(zadani) * rad                                                           ' vypocet hodnoty frekvence v Hz

if f <=0 then
   color 12,0
   print "Chybne zadani, frekvence musi byt kladna a nenulova!"
  color 7,0
  goto frekvence
endif

' ------------------------------------------------------------------------------
' --- Zjisteni pouziteho casovace ----------------------------------------------
' ------------------------------------------------------------------------------

casovac:                                                                        

color 15,0 : print "Pouzity casovac";
color 7,0 : print " [0/1]";
color 15,0 : input " - ",typ
color 7,0

if typ <>0 and typ<>1 then
   color 12,0
   print "Chybne zadani, je potreba zadat spravny typ casovace!"
   color 7,0
  goto casovac
endif

' ------------------------------------------------------------------------------
' --- Zjisteni pouzite preddelicky ---------------------------------------------
' ------------------------------------------------------------------------------

preddelicka:                                                                    

color 15,0 : print "Pouzita preddelicka";
color 7,0 : print " []";
color 15,0 : input " - ",pres
color 7,0

if pres <> 1 and pres <> 2 and pres <> 4 and pres <> 8 and pres <> 16 and pres <> 32 and pres <> 64 and pres <> 128 and pres <> 256and pres <> 512 and pres <> 1024 and pres <> 2048 then
   color 12,0
   print "Chybne zadani, preddelicka smi mit jen hodnoty 1,2,4,8,16,32,64,128,256,512,1024 nebo 2048!"
   color 7,0
  goto preddelicka
endif

' ------------------------------------------------------------------------------
' --- Zisteni pozadovane periody preruseni -------------------------------------
' ------------------------------------------------------------------------------

perioda:                                                                         

color 15,0 : print "Pozadovana perioda preruseni";
color 7,0 : print " [us/ms/s]";
color 15,0 : input " - ",zadani
color 7,0

if right (zadani,1) = "u" then                                                  ' Vypocet zadane doby v sekundach
         rad=0.000001                                                               
   elseif right (zadani,1) = "m" then                                           
         rad=0.001
   else                                                                         
         rad = 1
endif

t = val(zadani) * rad                                                           ' konec

if t<=0 then                                                                  ' Kontrola zadani
   color 12,0
   print "Chybne zadani, perioda musi byt kladna a nenulova!"
   color 7,0
   goto perioda
endif

' ------------------------------------------------------------------------------
' --- Vlastni vypocet ----------------------------------------------------------
' ------------------------------------------------------------------------------

cls
print
print
color 14,0
print "   Zadane hodnoty:"
print "   ---------------"
print
color 7,0 : print "Hodinovy kmitocet:"; : color 15,0: print f; : color 7,0 : print " Hz"
color 7,0 : print "Preddelicka      :"; : color 15,0 : print pres 
color 7,0 : print "Pouzity casovac  : ";

if typ = 0 then
   color 15,0: print "8 bitovy"
else
    color 15,0: print "16 bitovy"
endif
color 7,0 : print "Preruseni kazdych:"; : color 15,0: print format (t," 0.0#############"); : color 7,0 : print " s"

print : print
color 14,0
print "   Vypocitane hodnoty:"
print "   -------------------"
print
color 7,0 

if typ=0 then                                                                   ' Vypocet pro 8bitovy casovac
   for x = 0 to 255                                                             ' Je celkem 256 vysledku
       vysledky(x) = 1/( (f/(256-x)/pres))                                      ' Do pameti si ulozim vsechny vysledky
   next x                                                                       ' Dokud nejsem hotova, tak plnim pamet
   minimum = 256
   p = 0
   for x = 0 to 255                                                             ' Je v pameti presny vysledek?                                  
       if vysledky(x) = t  then                                                 ' ano je, tak si jej zapamatuju
            vysledek = x
            p = 1                                                               ' priznak nalezeneho vysledku
       endif     
    next x
    if p = 0 then                                                               ' Presny vysledek neni, tak najdu nejblizsi 
        for x = 0 to 255   
            odchylka = abs(vysledky(x)-t)                                       ' vypocitam si odchylku                                   
            if minimum > odchylka then
               minimum = odchylka                                               ' pokud je odchylka mensi nez byla, mam nove minimum
               vysledek = x
            endif   
        next x
    endif
else                                                                            ' Vypocet pro 16bitovy casovac
   for x = 0 to 65535                                                           ' Je celkem 65536 vysledku
       vysledky(x) = 1/( (f/(65536-x)/pres))                                      ' Do pameti si ulozim vsechny vysledky
   next x                                                                       ' Dokud nejsem hotova, tak plnim pamet
   minimum = 256
   p = 0
   for x = 0 to 65535                                                           ' Je v pameti presny vysledek?                                  
       if vysledky(x) = t  then                                                 ' ano je, tak si jej zapamatuju
            vysledek = x
            p = 1                                                               ' priznak nalezeneho vysledku
       endif     
    next x
    if p = 0 then                                                               ' Presny vysledek neni, tak najdu nejblizsi 
        for x = 0 to 65535   
            odchylka = abs(vysledky(x)-t)                                       ' vypocitam si odchylku                                   
            if minimum > odchylka then
               minimum = odchylka                                               ' pokud je odchylka mensi nez byla, mam nove minimum
               vysledek = x
            endif   
        next x
    endif
endif

if typ=0 then                                                                   ' Vypsani vysledku pro 8bitovy casovac
   if p = 1 then                                                                ' Vypsani presneho vysledku
      color 10,0 : print "Zadanou dobu periody lze presne dodrzet."
      print : color 7,0
      print "Registr tc ="; : color 15,0: print vysledek; : color 7,0 : print "."
   else                                                                         ' Vypsani vysledku s odchylkou
      color 12,0 : print "Zadanou dobu periody nelze presne dodrzet."
      print : color 7,0
      print "Registr tc ="; : color 15,0: print vysledek; : color 7,0 : print "."
      print "Perioda preruseni: "; : color 15,0: print format ((1/((f/(256-vysledek)/pres))),"0.0###########");
      color 7,0 : print " s."
      print "Odchylka: "; : color 15,0: print format (minimum,"0.0###########"); : color 7,0 : print " s"
   endif
else                                                                            ' Vypsani vysledku pro 16bitovy casovac
   tch = fix(vysledek/256)                                                      ' vypocet tch
   tcl = vysledek-(tch*256)                                                     ' vypocet tcl

   if p = 1 then                                                                ' Vypsani presneho vysledku
      color 10,0 : print "Zadanou dobu periody lze presne dodrzet."
      print : color 7,0
      print "Registr tch ="; : color 15,0: print tch; : color 7,0
      print " a tcl ="; : color 15,0 : print tcl; : color 7,0 : print "."
   else                                                                         ' vypsani vysledku s odchylkou
      color 12,0 : print "Zadanou dobu periody nelze presne dodrzet."
      print : color 7,0
      print "Registr tch ="; : color 15,0: print tch; : color 7,0
      print " a tcl ="; : color 15,0 : print tcl; : color 7,0 : print "."
      print "Perioda preruseni: "; : color 15,0: print format ((1/((f/(65536-vysledek)/pres))),"0.0###########") ; : color 7,0 : print " s"
      print "Odchylka: "; : color 15,0: print format (minimum,"0.0###########"); : color 7,0 : print " sekundy."
   endif
endif

' ------------------------------------------------------------------------------
' --- Dalsi vypocet? -----------------------------------------------------------
' ------------------------------------------------------------------------------

print
print
color 7,0
input "  Dalsi vypocet? ", zadani

if lcase(zadani) = "n" or lcase(zadani) = "ne" then
   print : print "Dekuji za pouziti :-)"
   end 0
else
    goto zacatek
endif

' ------------------------------------------------------------------------------
' --- Vypsani napovedy k programu ----------------------------------------------
' ------------------------------------------------------------------------------

napoveda:
cls
color 10,0
print "              Vypocet periody preruseni pro 8 a 16 bitovy casovac              "
print "                             procesoru Atmel AVR                               "
print "              ---------------------------------------------------              "
print
color 7,0
print "Program slouzi k vypoctu periody preruseni pro procesory Atmel AVR."
print "Nejprve se zepta na dulezite udaje a potom provede vlastni vypocet. Frekvence"
print "se zadava v Hz a doba periody v s. Program vsak umi rozpoznat jine hodnoty a "
print "si je je prepocitat na zakladni jednotky. Proto je mozne zadavat takto:"
print
print "      10"; : color 14,0 : print "M"; : color 7,0 : print " - 10 MHz       10"; : color 14,0 : print "m"; : color 7,0 : print " - 10 ms"
print "      10"; : color 14,0 : print "k"; : color 7,0 : print " - 10 kHz       10"; : color 14,0 : print "u"; : color 7,0 : print " - 10 us"
print
print "Pokud se nezada zadna predpona, nebo se zada jina, povazuje program hodnotu za"
print "zakladni jednotku. Program hlida zakladni smysluplnost zadani."
color 12,0
print
print "POZOR! Ne kazdy procesor umi kazdou hodnoty predelicky! Je potreba se podivat"
print "do dokumentace prislusneho procesoru."
color 7,0
print
print "Program lze spustit s temito parametry:"
print "bez parametru - normalni beh programu
print "/h            - tento text"
print "/v            - vypsani verze a licence programu"
print
end 0

' ------------------------------------------------------------------------------
' --- Vypsani verze k programu -------------------------------------------------
' ------------------------------------------------------------------------------

verze:
print
print "Jmeno programu:   Vypocet periody preruseni pro 8 a 16 bitovy casovac"
print "                  procesoru Atmel AVR"
print "Autorka programu: Sasa Svobodova - sasa@zirafoviny.cz"
print "Verze programu:   1.0"
print "Datum kompilace:  29. 5. 2008"
print
print
print "Tento program je svobodny software; muzete jej sirit a modifikovat podle"
print "ustanoveni GNU General Public License, vydavane Free Software Foundation."
print
print "Tento program je rozsirovan v nadeji, ze bude uzitecny, avsak"
print "BEZ JAKEKOLI ZARUKY; neposkytuji se ani odvozene zaruky PRODEJNOSTI anebo"
print "VHODNOSTI PRO URCITY UCEL. Dalsi podrobnosti hledejte v"
print "GNU General Public License."
print
print "Kopii GNU General Public License jste mel/a obdrzet spolu s timto"
print "programem. Pokud se tak nestalo, napiste si o ni Free Software"
print "Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA."
print

end 0