' ------------------------------------------------------------------------------
' --- Program pro vypocet multivibratoru  --------------------------------------
' ------------------------------------------------------------------------------

#include "vbcompat.bi"                                                          ' vlozeni hlavickoveho souboru 

' ------------------------------------------------------------------------------
' --- Promenne a jejich dimenzovani --------------------------------------------
' ------------------------------------------------------------------------------

dim zadani as string, R1 as double,R2 as double,C1 as double,C2 as double
dim rad as double, un as double, ub as double, t1 as double, t2 as double
dim f as double, f1 as double, argv As String, typ as byte

' ------------------------------------------------------------------------------
' --- Ziskani hodnoty parametru spusteni, pokud je -----------------------------
' ------------------------------------------------------------------------------

  argv = Command( 1 )                                                           ' argv je pole obsahujici parametry predane pri spusteni

	if argv = "/h" then
	  goto napoveda
	elseif argv = "/p" then
	  goto zacatek
	elseif argv = "/v" then
	  goto verze
	endif
	  goto zacatek

' ------------------------------------------------------------------------------
' --- Ziskani hodnot od uzivatele ----------------------------------------------
' ------------------------------------------------------------------------------

zacatek:
color 10,0
cls

print 
print "    Vypocet frekvence tranzistoroveho multivibratoru"
print "    ------------------------------------------------"
print

color 7,0

' ------------------------------------------------------------------------------
' --- Hodnota R1 a jeji kontrola -----------------------------------------------
' ------------------------------------------------------------------------------

odpor_r1:
input "Hodnota odporu       R1: ",zadani
if right (zadani,1) = "k" then                                                  ' Urceni radu soucastky
         rad=1000                                                               ' pokud je na konci "k" jsou to kiloohmy
   elseif right (zadani,1) = "M" then                                           ' pokud tam je "M" jsou to megaohmy
         rad=1000000
   else                                                                         ' pokud tam je neco jineho, jsou to ohmy 
        rad = 1
endif      
R1 = val(zadani) * rad                                                          ' vypocet hodnoty odporu v ohmech

if R1 <=0 then
   color 12,0
   print "Chybne zadani, odpor musi byt kladny a nenulovy!"
   color 7,0
   goto odpor_r1
endif

' ------------------------------------------------------------------------------
' --- Hodnota R2 a jeji kontrola -----------------------------------------------
' ------------------------------------------------------------------------------

odpor_r2:
input "Hodnota odporu       R2: ",zadani
if right (zadani,1) = "k" then
         rad=1000
   elseif right (zadani,1) = "M" then
         rad=1000000
   else 
        rad = 1
endif      
R2 = val(zadani) * rad

if r2 <=0 then
   color 12,0
   print "Chybne zadani, odpor musi byt kladny a nenulovy!"
   color 7,0
   goto odpor_r2
endif

' ------------------------------------------------------------------------------
' --- Hodnota C1 a jeji kontrola -----------------------------------------------
' ------------------------------------------------------------------------------

kapacita_c1:
input "Hodnota kondenzatoru C1: ",zadani
if right (zadani,1) = "p" then '                                                ' pokud je na konci "p" jsou to pikofarady
         rad=0.0000000000001
   elseif right (zadani,1) = "n" then                                           ' "n" jsou nanofarady
         rad=0.000000001
   elseif right (zadani,1) = "u" then                                           ' "u" jsou mikrofarady
         rad=0.000001
   elseif right (zadani,1) = "m" then                                           ' "m" jsou milifarady
         rad=0.001
   else                                                                         ' cokoli jineho jsou farady 
        rad = 1
endif      
C1 = val(zadani) * rad                                                          ' vypocet hodnoty kondenzatoru

if c1 <=0 then
   color 12,0
   print "Chybne zadani, kapacita musi byt kladna a nenulova!"
   color 7,0
   goto kapacita_c1
endif

' ------------------------------------------------------------------------------
' --- Hodnota C2 a jeji kontrola -----------------------------------------------
' ------------------------------------------------------------------------------

kapacita_c2:
input "Hodnota kondenzatoru C2: ",zadani
if right (zadani,1) = "p" then
         rad=0.0000000000001
   elseif right (zadani,1) = "n" then
         rad=0.000000001
   elseif right (zadani,1) = "u" then
         rad=0.000001
   elseif right (zadani,1) = "m" then
         rad=0.001
   else 
        rad = 1
endif      
C2 = val(zadani) * rad

if c2 <=0 then
   color 12,0
   print "Chybne zadani, kapacita musi byt kladna a nenulova!"
   color 7,0
   goto kapacita_c2
endif

' ------------------------------------------------------------------------------
' --- Hodnota napajeciho napeti ------------------------------------------------
' ------------------------------------------------------------------------------

napeti_un:
input "Napajeci napeti      Un: ",un
typ = 1
if un <0 then typ = 2                                                           ' Typ1 = NPN; typ2 = PNP
un = abs(un)                                                                    ' Absolutni hodnota, nekdo muze zadat
                                                                                ' i zaporne napeti pro PNP
if un = 0 then
   color 12,0
   print "Chybne zadani, obvod musi byt napajen!"
   color 7,0
   goto napeti_un
endif
                                                     
' ------------------------------------------------------------------------------
' --- Hodnota bazoveho napeti, oba tranzistory maji stejny ---------------------
' ------------------------------------------------------------------------------

napeti_ub:
input "Napeti bazi          Ub: ",ub
ub = abs(ub)

if ub = 0 then
   color 12,0
   print "Chybne zadani, baze ma vzdy ubytek napeti!"
   color 7,0
   goto napeti_ub
elseif ub >= un then
   color 12,0    
   print "Chybne zadani, ubytek na bazy je vetsi nez napajeci napeti!"
   color 7,0
   goto napeti_ub
endif 

print : input "Souhlasi hodnoty? ",zadani
if lcase(zadani) = "n" or lcase(zadani) = "ne" then 
   goto zacatek
endif


' ------------------------------------------------------------------------------
' --- Vlastni vypocet ----------------------------------------------------------
' ------------------------------------------------------------------------------

cls
print
print
color 14,0
print "     Zapojeni obvodu                    Zadane hodnoty:"
print "     ---------------                    ---------------"
if typ = 1 then
   color 7,0 : print " o---*------*----*------*       "
   color 7,0 : print " +   |      |    |      |       "
   color 7,0 : print "     Rc1    R1   R2     Rc2     "; : color 7,0 : print "     R1 [ohm] ="; : color 15,0: print r1
   color 7,0 : print "     |      |    |      |       "; : color 7,0 : print "     R2 [ohm] ="; : color 15,0: print r2
   color 7,0 : print "     *--C1--*-  -*--C2--*----o v"; : color 7,0 : print "     C1   [F] ="; : color 15,0: print format (c1," 0.0#############")
   color 7,0 : print "     |        \/        |      y"; : color 7,0 : print "     C2   [F] ="; : color 15,0: print format (c2," 0.0#############")
   color 7,0 : print "     |C       /\       C|      s"; : color 7,0 : print "     Un   [V] ="; : color 15,0: print format (un," 0.0####")
   color 7,0 : print "   T1   B-----  -----B    T2   t"; : color 7,0 : print "     Ub   [V] ="; : color 15,0: print format (ub," 0.0####")
   color 7,0 : print " -   |E npn        npn E|      u"
   color 7,0 : print " o---*------------------*----o p"
else
   color 7,0 : print " o---*------*----*------*       "
   color 7,0 : print " -   |      |    |      |       "
   color 7,0 : print "     Rc1    R1   R2     Rc2     "; : color 7,0 : print "     R1 [ohm] ="; : color 15,0: print r1
   color 7,0 : print "     |      |    |      |       "; : color 7,0 : print "     R2 [ohm] ="; : color 15,0: print r2
   color 7,0 : print "     *--C1--*-  -*--C2--*----o v"; : color 7,0 : print "     C1   [F] ="; : color 15,0: print format (c1," 0.0#############")
   color 7,0 : print "     |        \/        |      y"; : color 7,0 : print "     C2   [F] ="; : color 15,0: print format (c2," 0.0#############")
   color 7,0 : print "     |C       /\       C|      s"; : color 7,0 : print "     Un   [V] ="; : color 15,0: print format (un," 0.0####")
   color 7,0 : print "   T1   B-----  -----B    T2   t"; : color 7,0 : print "     Ub   [V] ="; : color 15,0: print format (ub," 0.0####")
   color 7,0 : print " +   |E pnp        pnp E|      u"
   color 7,0 : print " o---*------------------*----o p"
endif   
   
print

color 14,0
print "     Vypoctene hodnoty:"
print "     ------------------"
color 7,0
                                                                                ' Vypocet hodnot
T1 = R1 * C1 * log((2*un - ub) / (un - ub))                                     ' vypocet doby trvani useku t1     
T2 = R2 * C2 * log((2*un - ub) / (un - ub))                                     ' vypocet doby trvani useku t2
f = 1 / (t1 +t2)                                                                ' vypocet frekvence

' ------------------------------------------------------------------------------
' --- Vypsani vysledku ---------------------------------------------------------
' ------------------------------------------------------------------------------

if argv="/p" then ' Zobrazeni presneho vypoctu se vsemi cisly

  color 7,0
	print " Doba    t1 =";
	if t1 < 0.000001 then
	   color 15,0 : print t1*1000000000;" ns"; : color 7,0 : print " (";t1;" s)"
	elseif t1 < 0.001 then
	   color 15,0 : print t1*1000000; " us"; : color 7,0 : print " (";t1;" s)"
	elseif t1 < 1 then
	   color 15,0 : print t1*1000 ;" ms"; : color 7,0 : : print " (";t1;" s)"
	else
	   color 15,0 : print t1;" s"
	endif

  color 7,0
	print " Doba    t2 =";
	if t2 < 0.000001 then
	   color 15,0 : print t2*1000000000; " ns"; : color 7,0 : : print " (";t2;" s)"
	elseif t2 < 0.001 then
	   color 15,0 : print t2*1000000; " us"; : color 7,0 : print " (";t2;" s)"
	elseif t2 < 1 then
	   color 15,0 : print t2*1000; " ms"; : color 7,0  : print " (";t2;" s)"
	else
	   color 15,0 : print t2; " s"
	endif

  color 7,0
	print " Frekvence f=";                                                        ' Pokud je frekvence vyssi nez 1GHz
	if (f/1000000000) > 1 then                                                    ' tak zobrazuji primo v GHz (v zavorce jsou Hz)
	   color 15,0 : print f/1000000000; " GHz";
		 color 7,0 :  print " (";f;" Hz)"
	elseif (f/1000000) > 1 then                                                   ' MHz
	   color 15,0 : print f/1000000; " MHz";
		 color 7,0 :  print " (";f;" Hz)"
	elseif (f/1000) >1 then
	   color 15,0 : print f/1000;" kHz";							                            ' kHz
		 color 7,0 :  print " (";f;" Hz)"
	else
	   color 15,0 : print f; " Hz"                                                ' Hz
	endif

else ' Zobrazeni zaokrouhleneho vysledku

	color 7,0
	print " Doba    t1 =";
	if t1 < 0.000001 then
	   color 15,0 : print format ((t1*1000000000),"  0.0##### ns")
	elseif t1 < 0.001 then
	   color 15,0 : print format ((t1*1000000),"  0.0## us")
	elseif t1 < 1 then
	   color 15,0 : print format ((t1*1000),"  0.0## ms")
	else
	   color 15,0 : print format (t1,"  0.0## s")
	endif
	
	color 7,0
	print " Doba    t2 =";
	if t1 < 0.000001 then
	   color 15,0 : print format ((t2*1000000000),"  0.0##### ns")
	elseif t1 < 0.001 then
	   color 15,0 : print format ((t2*1000000),"  0.0## us")
	elseif t1 < 1 then
	   color 15,0 : print format ((t2*1000),"  0.0## ms")
	else
	   color 15,0 : print format (t2,"  0.0## s")
	endif

	color 7,0
	print " Frekvence f=";                                                        ' Frekvence se zobrazuje v inteligentnich jednotkach
	if (f/1000000000) > 1 then                                                    ' takze ne 1234567894561321 Hz  ale 123.45654 GHz a podobne
	   color 15,0 : print format ((f/1000000000),"  0.0##### GHz")                ' GHz
	elseif (f/1000000) > 1 then                                                   
	   color 15,0 : print format ((f/1000000),"  0.0##### MHz")										' MHz
	elseif (f/1000) >1 then
	   color 15,0 : print format ((f/1000),"  0.0##### kHz")                      ' kHz
	else
	   color 15,0 : print format (f,"  0.0########### Hz")                        ' Hz
	endif

endif


' ------------------------------------------------------------------------------
' --- Dalsi vypocet? -----------------------------------------------------------
' ------------------------------------------------------------------------------

print
print
color 7,0
input "  Vypocet dalsiho obvodu? ", zadani

if lcase(zadani) = "n" or lcase(zadani) = "ne" then 
   print : print "Dekuji za pouziti :-)"
   end 0
else
    goto zacatek
endif

' ------------------------------------------------------------------------------
' --- Vypsani napovedy k programu ----------------------------------------------
' ------------------------------------------------------------------------------


napoveda:
cls
print "           Vypocet frekvence tranzistoroveho multivibratoru"
print "           ------------------------------------------------"
print
print "Program slouzi k vypoctu frekvence tranzistoroveho multivibratoru.
print "Pred vypoctem se program zepta na udaje soucastek a pak provede vlastni vypocet."
print "Hodnoty se zadavaji bud v zakladnich jednotkach, cili v ohmech, faradech a"
print "voltech, ale program umi poznat predpony hodnot, takze je mozne zadat je takto:"
print
print "      10"; : color 14,0 : print "p"; : color 7,0 : print " - 10 pikofaradu       10"; : color 14,0 : print "k"; : color 7,0 : print " - 10 kiloohmu"
print "      10"; : color 14,0 : print "n"; : color 7,0 : print " - 10 nanofaradu       10"; : color 14,0 : print "M"; : color 7,0 : print " - 10 megaohmu"
print "      10"; : color 14,0 : print "u"; : color 7,0 : print " - 10 mikrofaradu"
print "      10"; : color 14,0 : print "m"; : color 7,0 : print " - 10 milifaradu"
print
print "Pokud se nezada zadna predpona, nebo se zada jina, povazuje program hodnotu za"
print "zakladni jednotku. Napeti se zadavaji vzdy ve voltech."
print "Pro jednoduchost se predpoklada stejny ubytek napeti na bazich tranzistoru."
print
print "Program lze spustit s temito parametry:"
print "bez parametru - normalni vypocet (se zaokrouhlenim)"
print "/p            - presny vypocet na plny pocet mist"
print "/h            - tento text"
print "/v            - vypsani verze a licence programu"
print
end 0

' ------------------------------------------------------------------------------
' --- Vypsani verze k programu -------------------------------------------------
' ------------------------------------------------------------------------------

verze:
print
print "Jmeno programu:   Vypocet frekvence tranzistoroveho multivibratoru"
print "Autorka programu: Sasa Svobodova - sasa@zirafoviny.cz"
print "Verze programu:   1.0 "
print "Datum kompilace:  29. 5. 2008"
print
print
print "Tento program je svobodny software; muzete jej sirit a modifikovat podle"
print "ustanoveni GNU General Public License, vydavane Free Software Foundation."
print
print "Tento program je rozsirovan v nadeji, ze bude uzitecny, avsak"
print "BEZ JAKEKOLI ZARUKY; neposkytuji se ani odvozene zaruky PRODEJNOSTI anebo"
print "VHODNOSTI PRO URCITY UCEL. Dalsi podrobnosti hledejte v"
print "GNU General Public License."
print
print "Kopii GNU General Public License jste mel/a obdrzet spolu s timto"
print "programem. Pokud se tak nestalo, napiste si o ni Free Software"
print "Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA."
print

end 0




