'-------------------------------------------------------------------------------
'-              Program pro demonstraci rizeni displeje KTM-S1201
'-                          s radicem NEC uPD7225
'-
'- Program nastavi displej a pak zobrazi cisla s pomoci dekoderu, pak bez nej,
'- zobrazi desetinou tecku, vyzkousi rezimy s blikanim znaku a take nastaveni
'- pozice znaku na displeji
'-
'-
'- Sck - hodinovy signal pro prenos mezi procesorem a modulem
'- Si - seriova data
'- Cd - prepinani prenosu prikazu a dat. CD=0 data
'-                                       CD=1 prikazy
'-
'- Cs - uvolneni prenosu                 CS=0 povoleni prenosu
'-                                       CS=1 blokovani prenosu, zakladni stav
'-
'- Res - reset radice displeje           Res=0 reset displeje
'-                                       Res=1 normalni provoz
'-
'-------------------------------------------------------------------------------
'
' ------------------------------------------------------------------------------
' ------------------------- Nastaveni prekladace -------------------------------
' ------------------------------------------------------------------------------

'$sim                                                        ' Odremovat pro zkouseni na simulatoru, jinak nechat takto
$regfile = "attiny4313.dat"                                 ' Pouzity procesor
$crystal = 1000000                                          ' Frekvence oscilatoru,
$hwstack = 32
$swstack = 8
$framesize = 40

' ------------------------------------------------------------------------------
' --- Konfigurace procesoru a periferii
' ------------------------------------------------------------------------------

Config Portb = Output
Config Portd = Output

Dim I As Byte
Dim X As Byte
Dim Xx As Byte
Dim Displej(30) As Byte

Sck Alias Portb.0
Si Alias Portb.1
Cd Alias Portb.2
Res Alias Portb.3
Cs Alias Portb.4

' ------------------------------------------------------------------------------
' --- Hlavni program
' ------------------------------------------------------------------------------

Reset Res                                                   ' Reset displeje
Set Cs
Set Cd
Waitms 1000
Set Res                                                     ' -----------------

Do

Displej(1) = &H40                                           ' Zapojeni modulu: Divide-by-4 time division drive, 1 / 3 Bias Method, Frequency division ratio 1/2^7
Displej(2) = &H30                                           ' 30 - asynchronni rezim, 31 - synchronni rezim
Displej(3) = &H18                                           ' 18 - blikani je vypnute, 1A - pomale blikani, 1B - rychle blikani
Displej(4) = &H11                                           ' 11 - zapnuti displeje, 10 - vypnuti displeje
Displej(5) = &H15                                           ' 15 - pouzit 7 seg. dekoder, 14 - bez dekoderu
Displej(6) = &H20                                           ' vymazani pameti

Set Cd : Reset Cs : Waitms 10                               ' cd= 1 > prenasi se prikazy
For I = 1 To 6                                              ' Prenos dat do displeje
       Shiftout Si , Sck , Displej(i) , 0 , 8 , 9
Next I
Set Cs : Waitms 10

'-------------------------------------------------------------------------------
'--- Zobrazeni cisel pomoci dekoderu
'-------------------------------------------------------------------------------
'

Displej(1) = &H15                                           ' zapnuti dekoderu
Displej(2) = &H18                                           ' vypnuti blikani
Displej(3) = &H20                                           ' smazani obrazove pameti

Reset Cd : Reset Cs : Waitms 10                             ' cd = 0 > prenasi se data co se zobrazi
For I = 1 To 3
   Shiftout Si , Sck , Displej(i) , 0 , 8 , 9
Next I
Set Cs : Waitms 10

Displej(1) = &H08
Displej(2) = &H07
Displej(3) = &H06
Displej(4) = &H05
Displej(5) = &H04
Displej(6) = &H03
Displej(7) = &H02
Displej(8) = &H01
Displej(9) = &H00
Displej(10) = &H0F
Displej(11) = &H0F
Displej(12) = &H0C

Reset Cd : Reset Cs : Waitms 10
For I = 1 To 12
   Shiftout Si , Sck , Displej(i) , 0 , 8 , 9
Next I
Set Cs : Waitms 10

Wait 1

'-------------------------------------------------------------------------------
'-- Zobrazeni desetinne tecky
'-------------------------------------------------------------------------------

X = 6
                                                            ' sekvence pro rozsviceni desetinne tecky
Displej(1) = &H14                                           ' vypnuti dekoderu
Displej(2) = &HE0 + X                                       ' nula je uplne v pravo a kazda dalsi doleva
Displej(3) = &HB8                                           ' je 2 4 6 8 ...
Displej(4) = &H15                                           ' ta uplne v levo je 22

Set Cd : Reset Cs : Waitms 10
For I = 1 To 4
       Shiftout Si , Sck , Displej(i) , 0 , 8 , 9
Next I
Set Cs : Waitms 10                                          '-------------------

Wait 5

'-------------------------------------------------------------------------------
'-- Smazani displeje
'-------------------------------------------------------------------------------

Set Cd : Reset Cs : Waitms 10
X = &H20
Shiftout Si , Sck , X , 0 , 8 , 9
Set Cs : Waitms 10

'-------------------------------------------------------------------------------
'-- Nastaveni pozice znaku
'-------------------------------------------------------------------------------

For I = 0 To 11

Set Cd : Reset Cs : Waitms 100
X = I * 2
X = &HE0 + X
Shiftout Si , Sck , X , 0 , 8 , 9                           ' uplne vlevo je pozice 22

Reset Cd : Waitms 10
Shiftout Si , Sck , I , 0 , 8 , 9
Set Cs : Waitms 10

Wait 1
Next I

Wait 5

'-------------------------------------------------------------------------------
'-- Cisla Bez Dekoderu
'-------------------------------------------------------------------------------

Displej(1) = &H14                                           ' vypnuti dekoderu
Displej(2) = &H18                                           ' vypnuti blikani
Displej(3) = &H20                                           ' smazani obrazove pameti

Set Cd : Reset Cs : Waitms 10
For I = 1 To 3
   Shiftout Si , Sck , Displej(i) , 0 , 8 , 9
Next I
Set Cs : Waitms 10


' Tabulka Znaku
'              Degf.cba
Displej(1) = &B00000110
Displej(2) = &B11100011
Displej(3) = &B10100111
Displej(4) = &B00110110
Displej(5) = &B10110101
Displej(6) = &B11110100
Displej(7) = &B00000111
Displej(8) = &B11110111
Displej(9) = &B00110111
Displej(10) = &B11010111
'               Degf.cba

For I = 1 To 10

 If I = 2 Then Displej(i) = Displej(i) Or &B00001000        ' desetinna tecka

   Reset Cd                                                 ' Budu posilat data
   Reset Cs                                                 ' Povoleni komunikace
   Waitms 10
   For X = 1 To 12                                          ' jeden znak se odesle 12x aby byl obsazeny cely displej
      Shiftout Si , Sck , Displej(i) , 0 , 8 , 9
   Next X
   Set Cs                                                   ' Konec komunikace

   Waitms 1000

Next I

Wait 5

'-------------------------------------------------------------------------------
'-- Pomale blikani jedne cislice
'-------------------------------------------------------------------------------

X = 8
Xx = X + 1

Displej(1) = &H00                                           ' smazani cele blikaci pameti, jinak bude blikat kde co
Displej(2) = &HE0 + X                                       ' nastaveni adresy "n"  nula je uplne vpravo
Displej(3) = &HCF                                           ' zapis dat do blikaci pameti, prvni hodnota
Displej(4) = &HE + Xx                                       ' nastaveni adresy "n+1"
Displej(5) = &HCF                                           ' zapis dat do blikaci pameti, druha hodnota
Displej(6) = &H1A                                           ' povoleni blikani

Set Cd : Reset Cs : Waitms 10
For I = 1 To 6
       Shiftout Si , Sck , Displej(i) , 0 , 8 , 9
Next I
Set Cs : Waitms 10                                          '-------------------

Wait 10

'-------------------------------------------------------------------------------
'-- Vypnuti blikani pred dalsim pokusem
'-------------------------------------------------------------------------------

X = &H18
Set Cd : Reset Cs : Waitms 10
Shiftout Si , Sck , X , 0 , 8 , 9
Set Cs

Wait 2

'-------------------------------------------------------------------------------
'-- Pomale blikani celeho displeje
'-------------------------------------------------------------------------------

For X = 0 To 11                                             ' Naplneni cele blikajici pameti daty FF

Displej(1) = &HE + X                                        ' nastaveni adresy "n"  nula je uplne vpravo
Displej(2) = &HCF                                           ' zapis dat do blikaci pameti, prvni hodnota
Xx = X + 1
Displej(3) = &HE + Xx                                       ' nastaveni adresy "n+1"
Displej(4) = &HCF                                           ' zapis dat do blikaci pameti, druha hodnota

Set Cd : Reset Cs : Waitms 10
For I = 1 To 4
       Shiftout Si , Sck , Displej(i) , 0 , 8 , 9
Next I
Set Cs : Waitms 10                                          '-------------------
Next X

X = &H1A
Set Cd : Reset Cs : Waitms 10
Shiftout Si , Sck , X , 0 , 8 , 9
Set Cs

Wait 10


'-------------------------------------------------------------------------------
'-- Rychle blikani
'-------------------------------------------------------------------------------

Set Cd : Reset Cs : Waitms 10
X = &H1B                                                    ' zapnuti rychleho blikani
Shiftout Si , Sck , X , 0 , 8 , 9
Set Cs

Wait 10

'-------------------------------------------------------------------------------
'-- Vypnuti blikani pred dalsim pokusem
'-------------------------------------------------------------------------------

X = &H18
Set Cd : Reset Cs : Waitms 10
Shiftout Si , Sck , X , 0 , 8 , 9
Set Cs

'-------------------------------------------------------------------------------
'-- Pismenka
'-------------------------------------------------------------------------------

Displej(1) = &H14                                           ' vypnuti dekoderu
Displej(2) = &H18                                           ' vypnuti blikani
Displej(3) = &H20                                           ' smazani obrazove pameti

Set Cd : Reset Cs : Waitms 10
For I = 1 To 3
   Shiftout Si , Sck , Displej(i) , 0 , 8 , 9
Next I
Set Cs : Waitms 10


' Tabulka Znaku
'              Degf.cba
Displej(1) = &B11010111                                     '0
Displej(2) = &B00000110                                     '1
Displej(3) = &B11100011                                     '2
Displej(4) = &B10100111                                     '3
Displej(5) = &B00110110                                     '4
Displej(6) = &B10110101                                     '5
Displej(7) = &B11110101                                     '6
Displej(8) = &B00000111                                     '7
Displej(9) = &B11110111                                     '8
Displej(10) = &B10110111                                    '9
Displej(11) = &B01110111                                    'A
Displej(12) = &B11110100                                    'b
Displej(13) = &B11010001                                    'C
Displej(14) = &B11100110                                    'd
Displej(15) = &B11110001                                    'E
Displej(16) = &B01110001                                    'F
Displej(17) = &B11010101                                    'G
Displej(18) = &B01110110                                    'H
Displej(19) = &B00000110                                    'I
Displej(20) = &B11000110                                    'J
Displej(21) = &B11010000                                    'L
Displej(22) = &B01100100                                    'N
Displej(23) = &B01110011                                    'P
Displej(24) = &B11110000                                    't
Displej(25) = &B11010110                                    'U
Displej(26) = &B10110110                                    'y
'               Degf.cba


Reset Cd : Reset Cs : Waitms 10
For I = 12 To 1 Step -1
      Shiftout Si , Sck , Displej(i) , 0 , 8 , 9
Next I
Set Cs : Waitms 10

Wait 5
Set Cd : Reset Cs : Waitms 10
X = &H20 : Shiftout Si , Sck , X , 0 , 8 , 9
Set Cs : Waitms 10

Reset Cd : Reset Cs : Waitms 10
For I = 24 To 13 Step -1
      Shiftout Si , Sck , Displej(i) , 0 , 8 , 9
Next I
Set Cs : Waitms 10

Wait 5

Set Cd : Reset Cs : Waitms 10
X = &H20 : Shiftout Si , Sck , X , 0 , 8 , 9
Set Cs : Waitms 10


Reset Cd : Reset Cs : Waitms 10
For I = 26 To 25 Step -1
      Shiftout Si , Sck , Displej(i) , 0 , 8 , 9
Next I
Set Cs : Waitms 10

Wait 5
Set Cd : Reset Cs : Waitms 10
X = &H20 : Shiftout Si , Sck , X , 0 , 8 , 9
Set Cs : Waitms 10


Loop


' ------------------------------------------------------------------------------
' ------------------------------ Konec programu --------------------------------
' ------------------------------------------------------------------------------

End                                                         ' Pokud se program dostane az sem, skonci v nekonecne smycce
